package puakma.addin.log;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import puakma.system.SystemContext;

/**
 * Filter which decides whether log items will be logged. The decision is made according
 * to the Tornado system log level.
 * 
 * @author Martin Novak, mn@puakma.net
 */
public class TornadoLogFilter implements Filter
{
  private SystemContext system;

  public TornadoLogFilter(SystemContext system)
  {
    this.system = system;
  }

  public boolean isLoggable(LogRecord record)
  {
    int sysLevel = system.getDebugLevel();
    int recLevel = record.getLevel().intValue();
    switch(sysLevel) {
      case 1:
        return recLevel >= 1000;
      case 2:
        return recLevel >= 900;
      case 3:
        return recLevel >= 700;
      case 4:
        return recLevel >= 300;
      case 5:
        return recLevel > Integer.MIN_VALUE;
      default:
        return false;
    }
  }
}
