package puakma.addin.log;

import java.util.logging.Logger;

import puakma.addin.pmaAddIn;
import puakma.addin.pmaAddInStatusLine;

public class TestLogAddin extends pmaAddIn
{
  private static final Logger logger = Logger.getLogger(TestLogAddin.class.getName());
  
  private boolean running;

  private pmaAddInStatusLine statusLine;

  public boolean addInReady()
  {
    synchronized(this) {
      return running;
    }
  }

  public void pmaAddInMain()
  {
    setAddInName("LOG");
    statusLine = createStatusLine();
    statusLine.setStatus("Starting...");
    
    m_pSystem.doInformation("Starting Log Testing Addin", null, null);
    
    while(!addInShouldQuit()) {
      synchronized(this) {
        try {
          logger.entering(TestLogAddin.class.getName(), "pmaAddInMain");
          logger.severe("SEVERE");
          logger.warning("WARNING");
          logger.info("INFO");
          logger.fine("FINE");
          logger.finer("FINER");
          logger.finest("FINEST");
          logger.exiting(TestLogAddin.class.getName(), "pmaAddInMain");
          
          this.wait(2000);
        }
        catch(Exception ex) {
          ex.printStackTrace();
        }
        running = true;
      }
    }
    
    synchronized(this) {
      running = false;
    }
  }

}
