package puakma.addin.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import puakma.system.SystemContext;

/**
 * Writes all log messages directly to the Tornado database. Note that filtering is done
 * at the different object {@link TornadoLogFilter}
 * 
 * @author Martin Novak, mn@puakma.net
 */
public class PuakmaLogHandler extends Handler
{
  private SystemContext system;

  public PuakmaLogHandler(SystemContext system)
  {
    this.system = system;
  }

  public void close() throws SecurityException
  {

  }

  public void flush()
  {

  }

  public void publish(LogRecord record)
  {
    Level level = record.getLevel();
    int levelValue = level.intValue();
    String[] params = convertObjArrayToStringArray(record.getParameters());

    if(levelValue >= 1000) {
      system.doError(record.getMessage(), null);
    }
    else if(levelValue >= 700) {
      system.doInformation(record.getMessage(), params, null);
    }
    else {
      int debugLevel = 5;
      if(levelValue >= 400)
        debugLevel = 4;
      system.doDebug(debugLevel, record.getMessage(), null);
    }
  }

  private String[] convertObjArrayToStringArray(Object[] parameters)
  {
    if(parameters == null)
      return null;
    String[] ret = new String[parameters.length];
    for(int i = 0; i < parameters.length; ++i) {
      if(parameters[i] != null)
        ret[i] = parameters[i].toString();
      else
        ret[i] = "";
    }
    return ret;
  }

}
